/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.io;

import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;

public class FileFinder {
    private File baseDir = null;
    private ArrayList contains = new ArrayList();
    private ArrayList found = new ArrayList();

    public FileFinder(File baseDir) {
        this.baseDir = baseDir;
    }

    public void matches(String regex) {
        if (regex == null || "".equals(regex)) {
            return;
        }
        this.contains.add(regex);
    }

    public void extension(String extension) {
        if (extension == null || "".equals(extension)) {
            return;
        }
        if (extension.startsWith(".")) {
            extension = extension.substring(1);
        }
        this.contains.add(".*?\\." + extension + "$");
    }

    public File[] find() {
        this.find(this.baseDir, false, false);
        return this.found.toArray(new File[this.found.size()]);
    }

    public File[] findRecursive() {
        this.find(this.baseDir, true, false);
        return this.found.toArray(new File[this.found.size()]);
    }

    public File[] findAll() {
        this.find(this.baseDir, false, true);
        return this.found.toArray(new File[this.found.size()]);
    }

    public File[] findAllRecursive() {
        this.find(this.baseDir, true, true);
        return this.found.toArray(new File[this.found.size()]);
    }

    private void find(File dir, boolean recursive, final boolean all) {
        if (dir == null || !dir.canRead()) {
            return;
        }
        File[] files = dir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                File f = new File(dir, name);
                if (!all && !f.isFile()) {
                    return false;
                }
                if (FileFinder.this.contains.size() == 0) {
                    return true;
                }
                String regex = null;
                for (int i = 0; i < FileFinder.this.contains.size(); ++i) {
                    regex = (String)FileFinder.this.contains.get(i);
                    if (!name.matches(regex)) continue;
                    return true;
                }
                return false;
            }
        });
        if (files != null) {
            for (int i = 0; i < files.length; ++i) {
                this.found.add(files[i]);
            }
        }
        if (!recursive) {
            return;
        }
        File[] dirs = dir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                File f = new File(dir, name);
                return f.isDirectory();
            }
        });
        for (int i = 0; i < dirs.length; ++i) {
            this.find(dirs[i], true, all);
        }
    }
}

